
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seja Parceiro - NT INDICA</title>
    
            <link rel="icon" href="imagem/logo.png">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        /* --- VARIÁVEIS CSS --- */
        :root {
            --primary: #2563eb;
            --primary-dark: #1d4ed8;
            --primary-light: #3b82f6;
            --secondary: #8b5cf6;
            --text-dark: #1e293b;
            --text-medium: #475569;
            --text-light: #64748b;
            --bg-light: #f8fafc;
            --bg-white: #ffffff;
            --border: #e2e8f0;
            --shadow-sm: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
            --shadow-lg: 0 20px 25px -5px rgba(0, 0, 0, 0.08);
            --shadow-xl: 0 25px 50px -12px rgba(0, 0, 0, 0.12);
            --radius-lg: 20px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* --- GERAL --- */
        * { box-sizing: border-box; margin: 0; padding: 0; }
        html { scroll-behavior: smooth; }
        body { font-family: 'Inter', sans-serif; color: var(--text-medium); background-color: var(--bg-light); overflow-x: hidden; line-height: 1.6; }
        a { text-decoration: none; transition: var(--transition); }
        ul { list-style: none; }
        img { max-width: 100%; height: auto; }
        .container { width: 100%; max-width: 1200px; margin: 0 auto; padding: 0 20px; }

        /* --- ANIMAÇÕES --- */
        .reveal { opacity: 0; transform: translateY(30px); transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1); }
        .reveal.active { opacity: 1; transform: translateY(0); }

        /* --- NAVBAR --- */
        .navbar {
            display: flex; justify-content: space-between; align-items: center;
            padding: 20px 5%; position: fixed; width: 100%; top: 0; z-index: 1000;
            background: rgba(255, 255, 255, 0.9); backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0,0,0,0.05); transition: var(--transition);
        }
        .navbar.scrolled { padding: 15px 5%; box-shadow: var(--shadow-sm); background: rgba(255, 255, 255, 0.98); }
        
        .logo-img { height: 45px; width: auto; object-fit: contain; }
        .brand-text { font-size: 1.5rem; font-weight: 800; color: var(--primary); letter-spacing: -0.5px; }
        
        .btn-nav { 
            padding: 10px 24px; border-radius: 50px; font-weight: 600; font-size: 0.9rem; 
            display: inline-flex; align-items: center; gap: 8px; border: 2px solid var(--primary);
            color: var(--primary); 
        }
        .btn-nav:hover { background: var(--primary); color: white; transform: translateY(-2px); }

        /* --- HERO SECTION --- */
        .hero {
            background: linear-gradient(135deg, #eff6ff 0%, #e0e7ff 100%);
            padding: 180px 5% 120px; text-align: center; position: relative; overflow: hidden;
        }
        .hero::before {
            content: ''; position: absolute; width: 600px; height: 600px;
            background: rgba(37, 99, 235, 0.05); border-radius: 50%;
            top: -200px; right: -100px; z-index: 0;
        }
        
        .hero-content { position: relative; z-index: 1; max-width: 900px; margin: 0 auto; }
        .hero h1 { 
            font-size: 3.5rem; font-weight: 800; margin-bottom: 24px; line-height: 1.1; letter-spacing: -1px; color: var(--text-dark);
        }
        .hero .highlight { color: var(--primary); position: relative; display: inline-block; }
        
        .hero p { 
            font-size: 1.25rem; color: var(--text-light); margin-bottom: 40px; 
            line-height: 1.7; max-width: 700px; margin-left: auto; margin-right: auto; 
        }
        
        .btn-hero {
            padding: 18px 45px; border-radius: 50px; font-weight: 700; font-size: 1.1rem;
            display: inline-flex; align-items: center; gap: 12px; transition: var(--transition);
            background: var(--primary); color: white; box-shadow: 0 10px 25px rgba(37, 99, 235, 0.3);
        }
        .btn-hero:hover { transform: translateY(-5px); box-shadow: 0 20px 40px rgba(37, 99, 235, 0.4); background: var(--primary-dark); }

        /* --- SEÇÕES COMUNS --- */
        .section-title { text-align: center; margin-bottom: 60px; }
        .section-title h2 { font-size: 2.5rem; color: var(--text-dark); font-weight: 800; margin-bottom: 15px; }
        .section-title p { color: var(--text-light); font-size: 1.1rem; }
        .section-padding { padding: 100px 5%; }

        /* --- STEPS --- */
        .steps-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 40px; max-width: 1100px; margin: 0 auto; }
        .step-card { 
            padding: 40px 30px; border-radius: var(--radius-lg); background: white; 
            border: 1px solid var(--border); text-align: center; position: relative; transition: var(--transition);
        }
        .step-card:hover { transform: translateY(-10px); border-color: var(--primary-light); box-shadow: var(--shadow-lg); }
        
        .step-number { 
            font-size: 4rem; font-weight: 900; color: #f1f5f9; position: absolute; 
            top: -20px; left: 50%; transform: translateX(-50%); z-index: 0; 
        }
        .step-icon { 
            width: 80px; height: 80px; background: #eef2ff; color: var(--primary); border-radius: 50%;
            display: flex; align-items: center; justify-content: center; font-size: 32px;
            margin: 0 auto 20px; position: relative; z-index: 1;
        }
        .step-card h3 { font-size: 1.3rem; margin-bottom: 10px; color: var(--text-dark); position: relative; z-index: 1; }
        .step-card p { font-size: 0.95rem; color: var(--text-light); position: relative; z-index: 1; }

        /* --- FEATURES --- */
        .features { background: white; }
        .feature-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 30px; max-width: 1200px; margin: 0 auto; }
        .feature-card {
            padding: 40px 30px; border-radius: var(--radius-lg); background: var(--bg-light);
            transition: var(--transition); border: 1px solid transparent;
        }
        .feature-card:hover { background: white; border-color: var(--border); box-shadow: var(--shadow-lg); transform: translateY(-5px); }
        .feature-icon { color: var(--primary); font-size: 2rem; margin-bottom: 20px; }
        .feature-card h3 { font-size: 1.3rem; margin-bottom: 10px; color: var(--text-dark); font-weight: 700; }

        /* --- PRICING --- */
        .pricing-grid { display: flex; justify-content: center; gap: 30px; flex-wrap: wrap; max-width: 1000px; margin: 0 auto; }
        .price-card {
            background: white; border-radius: var(--radius-lg); padding: 50px 40px; width: 100%; max-width: 380px;
            box-shadow: var(--shadow-sm); border: 1px solid var(--border); position: relative;
            display: flex; flex-direction: column; transition: var(--transition);
        }
        .price-card:hover { transform: translateY(-10px); box-shadow: var(--shadow-xl); }
        
        .price-card.featured { border: 2px solid var(--primary); transform: scale(1.05); z-index: 2; }
        .price-card.featured:hover { transform: scale(1.05) translateY(-10px); }
        
        .badge-popular {
            position: absolute; top: -15px; left: 50%; transform: translateX(-50%);
            background: var(--primary); color: white; padding: 6px 20px; border-radius: 30px;
            font-size: 0.8rem; font-weight: 700; text-transform: uppercase; letter-spacing: 1px;
        }
        
        .price-value { font-size: 3.5rem; font-weight: 800; color: var(--text-dark); margin: 15px 0; }
        .price-value small { font-size: 1rem; color: var(--text-light); font-weight: 500; }
        
        .benefits-list li { display: flex; align-items: center; gap: 10px; margin-bottom: 15px; color: var(--text-medium); }
        .benefits-list li i { color: var(--success); }
        
        .btn-price {
            width: 100%; padding: 16px; border-radius: 12px; font-weight: 700; text-align: center;
            background: var(--bg-light); color: var(--text-dark); transition: var(--transition);
        }
        .price-card.featured .btn-price { background: var(--primary); color: white; box-shadow: 0 10px 20px rgba(37, 99, 235, 0.3); }
        .btn-price:hover { transform: translateY(-3px); }

        /* --- FOOTER --- */
        footer { background: var(--text-dark); color: white; padding: 80px 5% 40px; text-align: center; }
        .footer-logo { font-size: 1.8rem; font-weight: 800; margin-bottom: 20px; display: inline-block; color: white; }
        .footer-links { display: flex; justify-content: center; gap: 30px; margin-bottom: 40px; flex-wrap: wrap; }
        .footer-links a { color: #94a3b8; font-size: 0.95rem; }
        .footer-links a:hover { color: white; }
        .copyright { color: #475569; font-size: 0.85rem; border-top: 1px solid rgba(255,255,255,0.1); padding-top: 30px; }

        @media (max-width: 768px) {
            .hero h1 { font-size: 2.5rem; }
            .price-card.featured { transform: scale(1); }
            .navbar { padding: 15px 5%; }
        }
    </style>
</head>
<body>

    <nav class="navbar" id="navbar">
        <div class="logo-area">
                            <img src="imagem/logo.png" alt="Logo" class="logo-img">
                    </div>
        <a href="admin_login.php" class="btn-nav"><i class="fas fa-lock"></i> Área do Parceiro</a>
    </nav>

    <section class="hero">
        <div class="hero-content reveal active">
            <h1>Crie seu próprio <br><span class="highlight">Clube de Vantagens</span></h1>
            <p>A plataforma completa para você gerenciar clientes, oferecer benefícios exclusivos e criar um clube de vantagens que fideliza de verdade.</p>
            <a href="novo_parceiro.php" class="btn-hero">QUERO SER UM PARCEIRO <i class="fas fa-arrow-right"></i></a>
        </div>
    </section>

    <section class="section-padding steps-section">
        <div class="section-title reveal">
            <h2>Como Funciona?</h2>
            <p>Em apenas 3 passos você começa a lucrar com sua rede.</p>
        </div>
        <div class="steps-grid">
            <div class="step-card reveal">
                <div class="step-number">01</div>
                <div class="step-icon"><i class="fas fa-user-plus"></i></div>
                <h3>Cadastre-se</h3>
                <p>Crie sua conta de parceiro gratuitamente e ganhe dias de teste para configurar seu painel.</p>
            </div>
            <div class="step-card reveal">
                <div class="step-number">02</div>
                <div class="step-icon"><i class="fas fa-share-nodes"></i></div>
                <h3>Divulgue</h3>
                <p>Use seu link exclusivo para atrair clientes. Eles se cadastram e entram automaticamente na sua rede.</p>
            </div>
            <div class="step-card reveal">
                <div class="step-number">03</div>
                <div class="step-icon"><i class="fas fa-sack-dollar"></i></div>
                <h3>Gerencie</h3>
                <p>Acompanhe vendas, renovações e ofereça Cashback para fidelizar todos os seus clientes.</p>
            </div>
        </div>
    </section>

    <section class="section-padding features">
        <div class="section-title reveal">
            <h2>Ferramentas Poderosas</h2>
            <p>Tudo o que você precisa em um único lugar.</p>
        </div>
        <div class="feature-grid">
            <div class="feature-card reveal">
                <div class="feature-icon"><i class="fas fa-chart-line"></i></div>
                <h3>Gestão Completa</h3>
                <p>Painel administrativo intuitivo para você controlar seus clientes, vendas e renovações.</p>
            </div>
            <div class="feature-card reveal">
                <div class="feature-icon"><i class="fas fa-wallet"></i></div>
                <h3>Sistema de Cashback</h3>
                <p>Fidelize seus clientes oferecendo dinheiro de volta em cada renovação ou indicação.</p>
            </div>
            <div class="feature-card reveal">
                <div class="feature-icon"><i class="fas fa-link"></i></div>
                <h3>Link Personalizado</h3>
                <p>Tenha seu próprio link de divulgação. Quem clica, se cadastra e já fica vinculado a você.</p>
            </div>
        </div>
    </section>

    <section class="section-padding pricing">
        <div class="section-title reveal">
            <h2>Nossos Planos</h2>
            <p>Escolha a melhor opção para o seu negócio.</p>
        </div>
        <div class="pricing-grid">
            <div class="price-card reveal">
                <div class="price-header">
                    <span class="plan-name">Plano Mensal</span>
                    <div class="price-value"><small>R$</small> 29,90</div>
                </div>
                <ul class="benefits-list">
                    <li><i class="fas fa-check-circle"></i> Painel Administrativo</li>
                    <li><i class="fas fa-check-circle"></i> Gestão Ilimitada</li>
                    <li><i class="fas fa-check-circle"></i> Sistema de Cashback</li>
                    <li><i class="fas fa-check-circle"></i> Suporte Básico</li>
                </ul>
                <a href="novo_parceiro.php" class="btn-price">Começar Agora</a>
            </div>

            <div class="price-card featured reveal">
                <div class="badge-popular">Melhor Escolha</div>
                <div class="price-header">
                    <span class="plan-name">Plano Anual</span>
                    <div class="price-value"><small>R$</small> 197,90</div>
                </div>
                <ul class="benefits-list">
                    <li><i class="fas fa-check-circle"></i> <b>Tudo do plano mensal</b></li>
                    <li><i class="fas fa-check-circle"></i> Desconto Exclusivo</li>
                    <li><i class="fas fa-check-circle"></i> Link Personalizado</li>
                    <li><i class="fas fa-check-circle"></i> Suporte Prioritário</li>
                </ul>
                <a href="novo_parceiro.php" class="btn-price">Quero este Plano</a>
            </div>
        </div>
    </section>

    <footer>
        <span class="footer-logo">NT INDICA</span>
        <div class="footer-links">
            <a href="admin_login.php">Login Parceiro</a>
            <a href="novo_parceiro.php">Criar Conta</a>
            <a href="index.php">Sou Cliente Final</a>
        </div>
        <div class="copyright">
            &copy; 2026 NT INDICA. Todos os direitos reservados.
        </div>
    </footer>

    <script>
        window.addEventListener('scroll', function() {
            var reveals = document.querySelectorAll('.reveal');
            for (var i = 0; i < reveals.length; i++) {
                var windowHeight = window.innerHeight;
                var elementTop = reveals[i].getBoundingClientRect().top;
                var elementVisible = 150;
                if (elementTop < windowHeight - elementVisible) {
                    reveals[i].classList.add('active');
                }
            }
            
            var navbar = document.getElementById('navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });
    </script>

</body>
</html>