
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>Seja um Parceiro</title>
    <link rel="icon" type="image/x-icon" href="imagem/favicon.ico">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        * { box-sizing: border-box; }

        html, body {
            height: 100%;
            width: 100%;
            overflow: hidden; /* Trava a rolagem da página */
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .register-container {
            background: white;
            
            /* AUMENTADO AQUI */
            padding: 35px; 
            width: 92%; 
            max-width: 480px; 
            /* ---------------- */

            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.08);
            text-align: center;
            
            display: flex;
            flex-direction: column;
            justify-content: center;
            
            /* Scroll interno se a tela for muito pequena na altura */
            max-height: 95vh;
            overflow-y: auto;
        }

        /* Logo ajustada */
        .logo-img { max-height: 60px; margin-bottom: 15px; object-fit: contain; max-width: 100%; }
        
        h2 { 
            color: #1e293b; margin: 0 0 5px 0; font-size: 1.5rem; font-weight: 800;
        }
        
        .subtitle { color: #64748b; margin-bottom: 20px; font-size: 0.9rem; line-height: 1.3; }
        .highlight { color: #0284c7; font-weight: 800; background: #e0f2fe; padding: 2px 6px; border-radius: 4px; }
        
        .form-group { position: relative; margin-bottom: 12px; text-align: left; }
        
        .form-group i {
            position: absolute; left: 15px; top: 50%; transform: translateY(-50%); color: #94a3b8; z-index: 1; font-size: 0.95rem;
        }
        
        /* Input ajustado */
        input { 
            width: 100%; 
            padding: 12px 12px 12px 45px;
            border: 1px solid #cbd5e1; 
            border-radius: 10px; 
            font-size: 1rem; 
            background: #f8fafc;
            transition: 0.3s;
            color: #334155;
        }

        input:focus { 
            outline: none; border-color: #0f172a; background: #fff; box-shadow: 0 0 0 3px rgba(15, 23, 42, 0.1); 
        }
        
        .form-group label { display: none; }

        button, .btn-login { 
            width: 100%; 
            padding: 14px; 
            background: #0f172a; 
            color: white; 
            border: none; 
            border-radius: 10px; 
            font-weight: 700; 
            font-size: 1rem; 
            cursor: pointer; 
            margin-top: 8px; 
            transition: 0.2s; 
            display: flex; align-items: center; justify-content: center; gap: 10px;
            text-decoration: none;
        }
        
        button:hover, .btn-login:hover { background: #334155; transform: translateY(-2px); }
        
        .alert { padding: 12px; border-radius: 8px; margin-bottom: 15px; font-size: 0.9rem; text-align: center; }
        .alert-error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }
        .alert-success { background: #dcfce7; color: #166534; border: 1px solid #bbf7d0; }
        
        .btn-login { background: #166534; display: inline-flex; margin-top: 10px; }

        .footer-link { margin-top: 15px; display: block; color: #64748b; text-decoration: none; font-size: 0.9rem; }
        .footer-link:hover { color: #0f172a; text-decoration: underline; }
    </style>
</head>
<body>

<div class="register-container">
    <div class="logo-container">
                     <img src="imagem/logo.png" alt="Logo" class="logo-img">
            </div>

            <h2>Seja um Parceiro</h2>
        <p class="subtitle">Ganhe <span class="highlight">5 DIAS GRÁTIS</span> de acesso!</p>
    
    
        <form method="POST">
        <input type="hidden" name="cadastrar_revenda" value="true">
        
        <div class="form-group">
            <i class="fas fa-user"></i>
            <input type="text" name="nome" placeholder="Nome Completo" required>
        </div>

        <div class="form-group">
            <i class="fas fa-envelope"></i>
            <input type="email" name="email" placeholder="Seu melhor e-mail" required>
        </div>

        <div class="form-group">
            <i class="fab fa-whatsapp"></i>
            <input type="text" name="whatsapp" placeholder="WhatsApp (com DDD)" required>
        </div>

        <div class="form-group">
            <i class="fas fa-lock"></i>
            <input type="password" name="senha" placeholder="Crie uma senha" required>
        </div>
        
        <button type="submit">CRIAR CONTA GRÁTIS <i class="fas fa-arrow-right"></i></button>
    </form>
    
    <a href="admin_login.php" class="footer-link">Já possui conta? <b>Fazer Login</b></a>
    </div>

</body>
</html>