
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>Admin - NT INDICA</title>
    <link rel="icon" type="image/x-icon" href="imagem/favicon.ico">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        /* --- CORREÇÃO DA BARRA DE ROLAGEM E LARGURA --- */
        * {
            box-sizing: border-box;
        }

        html, body {
            height: 100%;
            width: 100%;
            overflow: hidden; /* Bloqueia scroll da página */
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f1f5f9; /* Fundo Cinza Claro */
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.08);
            text-align: center;
            
            /* AJUSTE DE LARGURA E RESPONSIVIDADE */
            width: 90%; /* Ocupa 90% da tela no mobile */
            max-width: 460px; /* Aumentado para ficar mais largo no PC */
            margin: 20px; /* Margem de segurança */
            
            /* Scroll interno caso a tela seja muito pequena (ex: celular deitado) */
            max-height: 90vh;
            overflow-y: auto;
        }

        .logo-img { max-height: 70px; margin-bottom: 20px; object-fit: contain; max-width: 100%; }
        .brand-text { font-size: 1.8rem; font-weight: 800; color: #0f172a; margin-bottom: 20px; display: block; }

        h2 { 
            color: #1e293b; 
            margin: 0 0 10px 0; 
            font-size: 1.6rem; 
            font-weight: 800;
        }
        
        .badge-adm {
            background: #e0f2fe; color: #0369a1; 
            padding: 4px 10px; border-radius: 20px; 
            font-size: 0.8rem; font-weight: 700; 
            display: inline-block; margin-bottom: 15px;
            text-transform: uppercase;
        }

        .form-group { position: relative; margin-bottom: 15px; }
        
        .form-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #94a3b8;
        }

        input { 
            width: 100%; 
            padding: 14px 14px 14px 45px; 
            border: 1px solid #cbd5e1; 
            border-radius: 10px; 
            font-size: 1rem; 
            background: #f8fafc;
            transition: 0.3s;
            color: #334155;
        }

        input:focus { 
            outline: none; 
            border-color: #0f172a; /* Foco escuro para ADM */
            background: #fff; 
            box-shadow: 0 0 0 4px rgba(15, 23, 42, 0.1); 
        }
        
        button { 
            width: 100%; 
            padding: 15px; 
            background: #0f172a; /* Botão Escuro */
            color: white; 
            border: none; 
            border-radius: 10px; 
            font-weight: 700; 
            font-size: 1rem; 
            cursor: pointer; 
            margin-top: 10px; 
            transition: 0.2s; 
            display: flex; align-items: center; justify-content: center; gap: 10px;
        }
        
        button:hover { 
            background: #334155; 
            transform: translateY(-2px); 
        }

        /* Alertas */
        .alert { padding: 12px; border-radius: 8px; margin-bottom: 20px; font-size: 0.9rem; text-align: left; }
        .alert-error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; display: flex; align-items: center; gap: 8px;}

        /* Rodapé */
        .footer-links { margin-top: 25px; font-size: 0.9rem; color: #64748b; }
        .footer-links a { color: #64748b; text-decoration: none; font-weight: 500; }
        .footer-links a:hover { color: #0f172a; text-decoration: underline; }
    </style>
</head>
<body>

    <div class="login-container">
        <div class="logo-container">
                             <img src="imagem/logo.png" alt="Logo" class="logo-img">
                    </div>
        
        <span class="badge-adm"><i class="fas fa-user-shield"></i> Acesso Administrativo</span>
        <h2>Área Restrita</h2>

        
        <form method="POST">
            <div class="form-group">
                <i class="fas fa-envelope"></i>
                <input type="email" name="email" placeholder="E-mail do Administrador" required>
            </div>

            <div class="form-group">
                <i class="fas fa-lock"></i>
                <input type="password" name="senha" placeholder="Senha de Acesso" required>
            </div>
            
            <button type="submit" name="acessar">
                ACESSAR SISTEMA <i class="fas fa-sign-in-alt"></i>
            </button>
        </form>
        <div class="footer-links">
            <a href="novo_parceiro.php"><i class="fas fa-arrow-left"></i> Seja Um Parceiro</a>
        </div>
    </div>

</body>
</html>