<?php
/**
 * Página de Download Profissional
 * Layout Premium | Avisos de Segurança | Entrega Segura
 */

error_reporting(0);
ini_set('display_errors', 0);

$idPedido = $_GET['pedido'] ?? '';
$itemIndex = isset($_GET['item']) ? (int)$_GET['item'] : -1;
$idParceiro = $_GET['id'] ?? '';

if (empty($idPedido) || $itemIndex < 0 || empty($idParceiro)) {
    die("Acesso negado.");
}

$base_path = __DIR__ . '/data/';
$pedidos_file = $base_path . 'pedidos.json';
$parceiros_file = $base_path . 'parceiros.json';

$pedidos = json_decode(file_get_contents($pedidos_file), true) ?: [];
$parceiros = json_decode(file_get_contents($parceiros_file), true) ?: [];

$pedidoEncontrado = null;
foreach ($pedidos as $p) {
    if ($p['id'] === $idPedido && $p['id_parceiro'] === $idParceiro) {
        $pedidoEncontrado = $p;
        break;
    }
}

$parceiro = null;
foreach ($parceiros as $p) {
    if ((string)$p['id'] === $idParceiro) {
        $parceiro = $p;
        break;
    }
}

if (!$pedidoEncontrado || $pedidoEncontrado['status_pagamento'] !== 'pago') {
    die("Pedido não autorizado ou não pago.");
}

$item = $pedidoEncontrado['itens'][$itemIndex] ?? null;
if (!$item || empty($item['file'])) {
    die("Arquivo não encontrado.");
}

if (isset($_GET['action']) && $_GET['action'] === 'start') {
    $filePath = __DIR__ . '/downloads/' . $item['file'];
    if (file_exists($filePath)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filePath));
        readfile($filePath);
        exit;
    } else {
        die("Arquivo físico não encontrado no servidor.");
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Download Seguro | <?= htmlspecialchars($item['nome']) ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f8fafc; }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-6">
    <div class="max-w-xl w-full">
        <div class="bg-white rounded-[32px] shadow-2xl border border-slate-100 overflow-hidden">
            <div class="bg-slate-900 p-8 text-center text-white">
                <div class="w-20 h-20 bg-white/10 rounded-2xl flex items-center justify-center mx-auto mb-4">
                    <i class="ph-fill ph-shield-check text-4xl text-green-400"></i>
                </div>
                <h1 class="text-xl font-black tracking-tight mb-1">Download Seguro</h1>
                <p class="text-slate-400 text-xs uppercase tracking-widest font-bold">Verificação de Segurança Concluída</p>
            </div>

            <div class="p-8 sm:p-12">
                <div class="text-center mb-10">
                    <h2 class="text-2xl font-black text-slate-900 mb-2"><?= htmlspecialchars($item['nome']) ?></h2>
                    <p class="text-slate-500 text-sm">Seu arquivo está pronto para ser baixado.</p>
                </div>

                <div class="space-y-4 mb-10">
                    <div class="flex gap-4 p-4 bg-blue-50 rounded-2xl border border-blue-100">
                        <i class="ph ph-info text-blue-500 text-xl shrink-0"></i>
                        <div>
                            <p class="text-xs font-bold text-blue-900 mb-0.5">Link Temporário</p>
                            <p class="text-[11px] text-blue-700 leading-relaxed">Este link é exclusivo para sua conta e expira após o uso. Não compartilhe.</p>
                        </div>
                    </div>
                    <div class="flex gap-4 p-4 bg-amber-50 rounded-2xl border border-amber-100">
                        <i class="ph ph-warning-circle text-amber-500 text-xl shrink-0"></i>
                        <div>
                            <p class="text-xs font-bold text-amber-900 mb-0.5">Uso Único</p>
                            <p class="text-[11px] text-amber-700 leading-relaxed">Certifique-se de salvar o arquivo em um local seguro após o download.</p>
                        </div>
                    </div>
                </div>

                <div id="downloadArea">
                    <button onclick="startDownload()" class="w-full bg-slate-900 text-white py-5 rounded-2xl font-black text-sm flex items-center justify-center gap-3 hover:bg-slate-800 transition-all shadow-xl shadow-slate-200">
                        <i class="ph ph-download-simple text-xl"></i> INICIAR DOWNLOAD AGORA
                    </button>
                </div>

                <div id="loadingArea" class="hidden text-center">
                    <div class="inline-block animate-spin rounded-full h-8 w-8 border-4 border-slate-900 border-t-transparent mb-4"></div>
                    <p class="text-sm font-bold text-slate-900">Preparando seu arquivo...</p>
                    <p class="text-[11px] text-slate-400 mt-1">O download começará em instantes.</p>
                </div>
            </div>

            <div class="bg-slate-50 p-6 text-center border-t border-slate-100">
                <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Protegido por <?= htmlspecialchars($parceiro['nome'] ?? 'Sistema de Segurança') ?></p>
            </div>
        </div>

        <div class="mt-8 text-center">
            <a href="meus-pedidos.php?id=<?= $idParceiro ?>" class="text-slate-400 text-xs font-bold hover:text-slate-600 transition-all flex items-center justify-center gap-2">
                <i class="ph ph-arrow-left"></i> VOLTAR PARA MEUS PEDIDOS
            </a>
        </div>
    </div>

    <script>
        function startDownload() {
            document.getElementById('downloadArea').classList.add('hidden');
            document.getElementById('loadingArea').classList.remove('hidden');
            
            setTimeout(() => {
                window.location.href = window.location.href + '&action=start';
                setTimeout(() => {
                    document.getElementById('downloadArea').classList.remove('hidden');
                    document.getElementById('loadingArea').classList.add('hidden');
                }, 3000);
            }, 1500);
        }
    </script>
</body>
</html>
