<?php
session_start();

// Redireciona se não estiver logado
if(!isset($_SESSION['usuario'])){
    header("Location: admin_login.php");
    exit;
}

$usuario = $_SESSION['usuario'];
$parceiro_logado = $usuario['id'];

// Caminhos dos JSON
$produtosJson = __DIR__ . '/data/produtos.json';
if(!file_exists($produtosJson)){
    file_put_contents($produtosJson, '[]');
}
$produtosData = json_decode(file_get_contents($produtosJson), true) ?? [];

// Pasta de uploads
$uploadDir = __DIR__ . '/uploads/';
if(!is_dir($uploadDir)) mkdir($uploadDir, 0755);

// ID do produto a editar
$id_produto = $_GET['id'] ?? '';
$produto = array_values(array_filter($produtosData, fn($p)=>$p['id']==$id_produto && $p['id_parceiro']==$parceiro_logado))[0] ?? null;

if(!$produto){
    echo "<script>alert('Produto não encontrado!'); window.location='produtos.php';</script>";
    exit;
}

// Processa envio do formulário
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $nome = trim($_POST['nome'] ?? '');
    $descricao = trim($_POST['descricao'] ?? '');
    $valor = floatval($_POST['valor'] ?? 0);
    $categoria = trim($_POST['categoria'] ?? '');
    $status = ($_POST['status'] ?? 'inativo') === 'ativo' ? 'ativo' : 'inativo';

    // Imagens existentes
    $imagens = $_POST['imagens_existentes'] ?? [];

    // Upload de novas imagens
    if(isset($_FILES['imagens_novas'])){
        foreach($_FILES['imagens_novas']['tmp_name'] as $i => $tmpName){
            if($_FILES['imagens_novas']['error'][$i] === UPLOAD_ERR_OK){
                $ext = pathinfo($_FILES['imagens_novas']['name'][$i], PATHINFO_EXTENSION);
                $novoNome = uniqid().'_'.$i.'.'.$ext;
                if(move_uploaded_file($tmpName, $uploadDir.$novoNome)){
                    $imagens[] = 'uploads/'.$novoNome;
                }
            }
        }
    }

    // Atualiza produto
    foreach($produtosData as &$p){
        if($p['id'] === $id_produto){
            $p['nome'] = $nome;
            $p['descricao'] = $descricao;
            $p['valor'] = $valor;
            $p['categoria'] = $categoria;
            $p['status'] = $status;
            $p['imagens'] = $imagens;
        }
    }
    file_put_contents($produtosJson, json_encode($produtosData, JSON_PRETTY_PRINT));

    $_SESSION['produto_salvo'] = true;
    header("Location: editar_produto.php?id=".$id_produto);
    exit;
}
?>

<?php include('includes/header.php'); ?>

<main class="pt-24 px-4 sm:px-6 lg:px-8 max-w-5xl mx-auto">
    <h1 class="text-2xl font-bold mb-6 text-[var(--text-primary)]">Editar Produto</h1>

    <form method="POST" enctype="multipart/form-data" class="bg-[var(--menu-secondary)] dark:bg-[var(--menu-secondary)] shadow rounded p-6 border border-[var(--border-color)]">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Nome</label>
                <input type="text" name="nome" value="<?= htmlspecialchars($produto['nome']) ?>" required class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
            </div>
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Valor (R$)</label>
                <input type="number" name="valor" step="0.01" value="<?= htmlspecialchars($produto['valor']) ?>" required class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
            </div>
            <div class="md:col-span-2">
                <label class="block mb-1 text-[var(--text-secondary)]">Descrição</label>
                <textarea name="descricao" rows="3" class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]"><?= htmlspecialchars($produto['descricao']) ?></textarea>
            </div>
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Categoria</label>
                <input type="text" name="categoria" value="<?= htmlspecialchars($produto['categoria']) ?>" class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
            </div>
            <div>
                <label class="block mb-1 text-[var(--text-secondary)]">Status</label>
                <select name="status" class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
                    <option value="ativo" <?= $produto['status']=='ativo'?'selected':'' ?>>Ativo</option>
                    <option value="inativo" <?= $produto['status']=='inativo'?'selected':'' ?>>Inativo</option>
                </select>
            </div>

            <!-- Imagens existentes -->
            <div class="md:col-span-2">
                <label class="block mb-1 text-[var(--text-secondary)]">Imagens existentes</label>
                <div id="previewExistentes" class="flex flex-wrap gap-2">
                    <?php foreach($produto['imagens'] ?? [] as $index => $img): ?>
                    <div class="relative w-[48%] sm:w-auto" data-index="<?= $index ?>">
                        <img src="<?= htmlspecialchars($img) ?>" class="h-auto w-full rounded border border-gray-300">
                        <button type="button" class="absolute top-0 right-0 bg-red-500 text-white rounded-full w-5 h-5 flex items-center justify-center text-xs" onclick="removerImagemExistente(<?= $index ?>)">X</button>
                        <input type="hidden" name="imagens_existentes[]" value="<?= htmlspecialchars($img) ?>">
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Upload novas imagens -->
            <div class="md:col-span-2">
                <label class="block mb-1 text-[var(--text-secondary)]">Adicionar novas imagens</label>
                <input type="file" name="imagens_novas[]" accept="image/*" multiple id="novasImagensInput" class="w-full px-4 py-2 rounded border border-[var(--border-color)] bg-[var(--body-bg)] text-[var(--text-primary)]">
                <div id="previewNovas" class="mt-2 flex flex-wrap gap-2"></div>
            </div>
        </div>

        <div class="mt-4 flex flex-col sm:flex-row gap-2">
            <button type="submit" class="bg-[var(--accent)] text-white px-6 py-2 rounded shadow hover:bg-[var(--accent)]/90 flex-1">Salvar</button>
            <a href="produtos.php" class="bg-gray-400 text-white px-6 py-2 rounded shadow hover:bg-gray-500 flex-1 text-center">Cancelar</a>
        </div>
    </form>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Remove imagem existente
function removerImagemExistente(index){
    const div = document.querySelector(`#previewExistentes div[data-index='${index}']`);
    if(div) div.remove();
}

// Preview novas imagens
document.getElementById('novasImagensInput').addEventListener('change', function(){
    const preview = document.getElementById('previewNovas');
    preview.innerHTML = '';
    Array.from(this.files).forEach(file=>{
        const reader = new FileReader();
        reader.onload = e=>{
            const div = document.createElement('div');
            div.className = 'w-[48%] sm:w-auto relative';
            const img = document.createElement('img');
            img.src = e.target.result;
            img.className = 'h-auto w-full rounded border border-gray-300';
            const btn = document.createElement('button');
            btn.type = 'button';
            btn.innerText = 'X';
            btn.className = 'absolute top-0 right-0 bg-red-500 text-white rounded-full w-5 h-5 flex items-center justify-center text-xs';
            btn.onclick = ()=>div.remove();
            div.appendChild(img);
            div.appendChild(btn);
            preview.appendChild(div);
        };
        reader.readAsDataURL(file);
    });
});

// SweetAlert2 após salvar
<?php
if(isset($_SESSION['produto_salvo']) && $_SESSION['produto_salvo']){
    echo "document.addEventListener('DOMContentLoaded', function(){
        Swal.fire({
            icon: 'success',
            title: 'Produto salvo!',
            text: 'O produto foi atualizado com sucesso.',
            confirmButtonColor: '#0088CC'
        });
    });";
    unset($_SESSION['produto_salvo']);
}
?>
</script>