<?php
/**
 * Webhook PushinPay - Produção (Versão Alinhada com Documentação)
 */

$log_file = __DIR__ . '/webhook.log';
function log_debug($msg) {
    global $log_file;
    file_put_contents($log_file, "[" . date('Y-m-d H:i:s') . "] " . $msg . "\n", FILE_APPEND);
}

$payload = file_get_contents('php://input');
log_debug("Payload Recebido: " . $payload);

$data = json_decode($payload, true);
if (!$data) {
    log_debug("Erro: JSON inválido.");
    http_response_code(400);
    exit;
}

// Campos conforme documentação da PushinPay
$status = $data['status'] ?? '';
$external_id = $data['external_id'] ?? '';
$transaction_id = $data['id'] ?? '';

if (!$status) {
    log_debug("Erro: Campo 'status' ausente.");
    http_response_code(200);
    exit;
}

$pedidos_file = __DIR__ . '/data/pedidos.json';
if (!file_exists($pedidos_file)) {
    log_debug("Erro: Arquivo pedidos.json não encontrado.");
    http_response_code(200);
    exit;
}

$pedidos = json_decode(file_get_contents($pedidos_file), true) ?: [];
$updated = false;

foreach ($pedidos as &$p) {
    // Busca pelo ID do pedido (external_id) ou ID da transação (id)
    $match = false;
    if ($external_id && (string)$p['id'] === (string)$external_id) {
        $match = true;
    } elseif ($transaction_id && isset($p['transaction_id']) && (string)$p['transaction_id'] === (string)$transaction_id) {
        $match = true;
    }

    if ($match) {
        // Status documentados: 'paid', 'approved', 'canceled', 'expired'
        if ($status === 'paid' || $status === 'approved') {
            if ($p['status_pagamento'] !== 'pago') {
                $p['status_pagamento'] = 'pago';
                $p['pago_em'] = date('c');
                $updated = true;
                log_debug("Pedido {$p['id']} atualizado para PAGO.");
            }
        } elseif (in_array($status, ['canceled', 'expired', 'failed'])) {
            if ($p['status_pagamento'] !== 'cancelado') {
                $p['status_pagamento'] = 'cancelado';
                $updated = true;
                log_debug("Pedido {$p['id']} atualizado para CANCELADO.");
            }
        }
        break;
    }
}

if ($updated) {
    file_put_contents($pedidos_file, json_encode($pedidos, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
} else {
    log_debug("Nenhuma alteração realizada no pedido.");
}

http_response_code(200);
echo json_encode(['success' => true]);
?>
