<?php
include 'includes/menu.php';
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($parceiro["nome"]) ?> - Login/Cadastro</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
body { margin:0; font-family:'Inter',sans-serif; background:#f5f6fa; color:#333; }
.container { display:flex; justify-content:center; align-items:center; min-height:calc(100vh - 80px); padding:20px; }
.card { background:#fff; border-radius:16px; padding:40px 30px; width:100%; max-width:420px; box-shadow:0 15px 30px rgba(0,0,0,0.1); transition:0.3s; }
.card:hover { transform: translateY(-3px); box-shadow:0 20px 40px rgba(0,0,0,0.12); }
h2 { text-align:center; margin-bottom:24px; font-weight:700; color: var(--p-color,#2563eb); }
.tabs { display:flex; justify-content:center; margin-bottom:24px; }
.tab { padding:10px 24px; cursor:pointer; border-bottom:3px solid transparent; font-weight:600; transition:0.3s; color:#555; }
.tab.active { border-color: var(--p-color,#2563eb); color: var(--p-color,#2563eb); }
.input-group { margin-bottom:16px; }
.input-group input { width:100%; padding:14px 16px; border:1px solid #ccc; border-radius:12px; font-size:1rem; transition:0.2s; }
.input-group input:focus { border-color: var(--p-color,#2563eb); box-shadow:0 0 0 3px rgba(37,99,235,0.15); outline:none; }
.btn { width:100%; padding:14px; border:none; border-radius:12px; background: var(--p-color,#2563eb); color:#fff; font-weight:600; cursor:pointer; transition:0.3s; }
.btn:hover { transform:translateY(-2px); opacity:0.95; }
.hidden { display:none; }
</style>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>

<div class="container">
    <div class="card">
        <h2>Bem-vindo(a) à <?= htmlspecialchars($parceiro["nome"]) ?></h2>
        <div class="tabs">
            <div id="tabLogin" class="tab active" onclick="switchTab('login')">Entrar</div>
            <div id="tabCadastro" class="tab" onclick="switchTab('cadastro')">Cadastrar</div>
        </div>

        <!-- LOGIN -->
        <div id="loginForm">
            <div class="input-group">
                <input type="email" id="loginEmail" placeholder="E-mail">
            </div>
            <div class="input-group">
                <input type="password" id="loginSenha" placeholder="Senha">
            </div>
            <button class="btn" onclick="realizarLogin()">Entrar</button>
        </div>

        <!-- CADASTRO -->
        <div id="cadastroForm" class="hidden">
            <div class="input-group">
                <input type="text" id="regNome" placeholder="Nome Completo">
            </div>
            <div class="input-group">
                <input type="email" id="regEmail" placeholder="E-mail">
            </div>
            <div class="input-group">
                <input type="password" id="regSenha" placeholder="Senha">
            </div>
            <div class="input-group">
                <input type="text" id="regWhatsapp" placeholder="WhatsApp">
            </div>
            <button class="btn" onclick="realizarCadastro()">Cadastrar</button>
        </div>
    </div>
</div>

<script>
function switchTab(tab){
    document.getElementById('loginForm').classList.toggle('hidden', tab!=='login');
    document.getElementById('cadastroForm').classList.toggle('hidden', tab!=='cadastro');
    document.getElementById('tabLogin').classList.toggle('active', tab==='login');
    document.getElementById('tabCadastro').classList.toggle('active', tab==='cadastro');
}

function realizarLogin(){
    const email = document.getElementById('loginEmail').value;
    const senha = document.getElementById('loginSenha').value;
    if(!email||!senha) return Swal.fire('Erro','Preencha todos os campos','error');
    Swal.fire('Sucesso','Login realizado!','success');
}

function realizarCadastro(){
    const nome = document.getElementById('regNome').value;
    const email = document.getElementById('regEmail').value;
    const senha = document.getElementById('regSenha').value;
    const whatsapp = document.getElementById('regWhatsapp').value;
    if(!nome||!email||!senha) return Swal.fire('Erro','Preencha todos os campos','error');
    Swal.fire('Sucesso','Conta criada!','success');
}
</script>

</body>
</html>