<?php
// dashboard.php
include('includes/header.php');

// Pega a aba atual da URL
$tab = $_GET['tab'] ?? 'dashboard';
?>

<!-- MAIN CONTENT -->
<main class="ml-0 md:ml-64 pt-20 p-6 transition-all duration-300">
    <?php
    switch ($tab) {
        case 'clientes':
            echo '<h1 class="text-2xl font-bold mb-4">Clientes</h1>';
            echo '<p>Aqui você verá a lista de clientes cadastrados.</p>';
            // Exemplo: tabela de clientes
            echo '<div class="overflow-x-auto mt-4">
                    <table class="min-w-full bg-white border border-gray-200 rounded-lg">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="px-4 py-2 border-b">ID</th>
                                <th class="px-4 py-2 border-b">Nome</th>
                                <th class="px-4 py-2 border-b">Email</th>
                                <th class="px-4 py-2 border-b">WhatsApp</th>
                                <th class="px-4 py-2 border-b">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="px-4 py-2 border-b">1</td>
                                <td class="px-4 py-2 border-b">Ana</td>
                                <td class="px-4 py-2 border-b">ana@email.com</td>
                                <td class="px-4 py-2 border-b">5521980308707</td>
                                <td class="px-4 py-2 border-b">Ativo</td>
                            </tr>
                        </tbody>
                    </table>
                  </div>';
            break;

        case 'pedidos':
            echo '<h1 class="text-2xl font-bold mb-4">Pedidos</h1>';
            echo '<p>Aqui você verá os pedidos realizados.</p>';
            break;

        case 'solicitacoes':
            echo '<h1 class="text-2xl font-bold mb-4">Solicitações</h1>';
            echo '<p>Aqui você verá todas as solicitações enviadas pelos clientes.</p>';
            break;

        case 'servicos':
            echo '<h1 class="text-2xl font-bold mb-4">Produtos</h1>';
            echo '<p>Gerencie o catálogo de produtos.</p>';
            break;

        case 'perfil':
            echo '<h1 class="text-2xl font-bold mb-4">Configurações</h1>';
            echo '<p>Altere dados do seu perfil e preferências.</p>';
            break;

        case 'log':
            echo '<h1 class="text-2xl font-bold mb-4">Logs</h1>';
            echo '<p>Registros de atividade do painel.</p>';
            break;

        case 'revendedores':
            echo '<h1 class="text-2xl font-bold mb-4">Revendedores</h1>';
            echo '<p>Lista de revendedores cadastrados.</p>';
            break;

        default:
            echo '<h1 class="text-2xl font-bold mb-4">Dashboard</h1>';
            echo '<p>Bem-vindo ao painel administrativo!</p>';
            break;
    }
    ?>
</main>